@extends('admin.template.master')

@section('title')
    <section class="content-header">
        <h1>
            DBBL Payments
            <small></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! url('admin/') !!}"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Brand</li>
        </ol>
    </section>
@endsection

@section('main-content')
    <section class="content">
    @if(Session::has('message'))
            <div class="row">
                <div class="col-xs-12">
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        {{Session('message')}}
                    </div>
                </div>
            </div>
    @endif

        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">List</h3>
                        <div class="box-tools">
                            <div class="input-group input-group-sm" style="width: 150px;">
                                 
                            </div>
                        </div>
                    </div>
                    <div class="box-body table-responsive">
                        <table class="table table-hover" id="dbbl_payments_table">
                            <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Payment ID</th>
                                <th>Customer</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection



@section('javascripts')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#dbbl_payments_table').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": "{!! route('getDBBLPayments') !!}",
                "order": [[0, "desc"]],
                "columns": [
                    {data: 'order_id'},
                    {data: 'payment_id'},
                    {data: 'phone'},
                    {data: 'created_at'}
                ]
            });
        });
    </script>
@endsection